/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// I also parameterised the loop counts for flexibility and rearranged
// things for efficiency. Though it looks different it is still almost
// the same shader as the original I took from GlsSandbox.com, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

float sphere46(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color46(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float plane5(vec3 pt, vec3 center, vec3 u_x, vec3 u_y, float sx, float sy)
{
   pt-=center;
   vec3 normal = normalize(cross(u_x, u_y));
   float val = dot(pt, normal);
   return val;
}
vec3 plane_color5(vec3 pt, vec3 center, vec3 u_x, vec3 u_y, float sx, float sy)
{
   float v_x = dot(pt-center, u_x)/length(u_x)/length(u_x);
   float v_y = dot(pt-center, u_y)/length(u_y)/length(u_y);
   v_x/=sx;
   v_y/=sy;
   v_x = abs(fract(v_x));
   v_y = abs(fract(v_y));
   return vec3(v_x,v_y,1.0);
}
float grayscale6(vec3 pt, float time)
{
   return plane5(pt,vec3(0.0, 100.0, 0.0),vec3(4.0, 0.0, 0.0),vec3(0.0, 0.0, 4.0),100.0,100.0);
}
vec3 grayscale_color6(vec3 pt, float time)
{
  vec3 col = plane_color5(pt,vec3(0.0, 100.0, 0.0),vec3(4.0, 0.0, 0.0),vec3(0.0, 0.0, 4.0),100.0,100.0);
  float c = (col.x+col.y+col.z+1.0)/4.0;
  return vec3(c,c,c);
}
float sphere1(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color1(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float sphere2(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color2(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float and_not3(vec3 pt)
{
   float v1 = sphere1(vec3(0.0, 0.0, 0.0),1000.0,pt);
   float v2 = sphere2(vec3(0.0, 0.0, 0.0),990.0,pt);
   float res = max(v1,-v2);
   return res;
}
vec3 and_not_color3(vec3 pt)
{
   float v = sphere1(vec3(0.0, 0.0, 0.0),1000.0,pt);
   if (v>-0.8 && v<0.8) return sphere_color1(vec3(0.0, 0.0, 0.0),1000.0,pt);
   return sphere_color2(vec3(0.0, 0.0, 0.0),990.0,pt);
}
float color_choose4(vec3 pt, vec3 color) {
   return and_not3(pt);
}
vec3 color_choose_color4(vec3 pt, vec3 color) {
   return color;
}
float or_elem7(vec3 pt)
{
   float v1 = grayscale6(pt,time);
   float v2 = color_choose4(pt,vec3(0.7, 0.8, 1.0));
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color7(vec3 pt)
{
   float val = grayscale6(pt,time);
   if (val>-0.8 && val<0.8) return grayscale_color6(pt,time);
   return color_choose_color4(pt,vec3(0.7, 0.8, 1.0));
}
float rbox23(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color23(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float cube25(vec3 tl, vec3 br, vec3 pt)
{
   pt-=tl;   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s,0.0));
}
vec3 cube_color25(vec3 tl, vec3 br, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem39(vec3 pt)
{
   float v1 = rbox23(pt,vec3(5.0, 70.0, -10.0),vec3(30.0, 100.0, 10.0),5.0);
   float v2 = cube25(vec3(5.0, 90.0, -5.0),vec3(30.0, 100.0, 20.0),pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color39(vec3 pt)
{
   float val = rbox23(pt,vec3(5.0, 70.0, -10.0),vec3(30.0, 100.0, 10.0),5.0);
   if (val>-0.8 && val<0.8) return rbox_color23(pt,vec3(5.0, 70.0, -10.0),vec3(30.0, 100.0, 10.0),5.0);
   return cube_color25(vec3(5.0, 90.0, -5.0),vec3(30.0, 100.0, 20.0),pt);
}
float trans40(vec3 pt, vec3 delta)
{
   pt-=delta;
   return or_elem39(pt);
}
vec3 trans_color40(vec3 pt, vec3 delta)
{
    pt-=delta;
    return or_elem_color39(pt);
}
float color_choose41(vec3 pt, vec3 color) {
   return trans40(pt,vec3(0.0,0.0,10.0*cos(time*3.0+3.14159)));
}
vec3 color_choose_color41(vec3 pt, vec3 color) {
   return color;
}
float rbox18(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color18(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float rbox20(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color20(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem30(vec3 pt)
{
   float v1 = rbox18(pt,vec3(-50.0, 0.0, -10.0),vec3(-30.0, 50.0, 10.0),5.0);
   float v2 = rbox20(pt,vec3(-50.0, 50.0, -10.0),vec3(-30.0, 70.0, 10.0),5.0);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color30(vec3 pt)
{
   float val = rbox18(pt,vec3(-50.0, 0.0, -10.0),vec3(-30.0, 50.0, 10.0),5.0);
   if (val>-0.8 && val<0.8) return rbox_color18(pt,vec3(-50.0, 0.0, -10.0),vec3(-30.0, 50.0, 10.0),5.0);
   return rbox_color20(pt,vec3(-50.0, 50.0, -10.0),vec3(-30.0, 70.0, 10.0),5.0);
}
float rotx31(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(          vec3(1.0, 0.0, 0.0),
          vec3(0.0,cos(angle),sin(angle)),
          vec3(0.0,-sin(angle),cos(angle)));
   float v1 = or_elem30(center+m*(pt-center));
   return v1;
}
vec3 rotx_color31(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(          vec3(1.0, 0.0, 0.0),
          vec3(0.0,cos(angle),sin(angle)),
          vec3(0.0,-sin(angle),cos(angle)));
   vec3 v1 = or_elem_color30(center+m*(pt-center));
   return v1;
}
float color_choose32(vec3 pt, vec3 color) {
   return rotx31(pt,vec3(-40.0, 10.0, 0.0),1.5*cos(time*3.0+3.14159));
}
vec3 color_choose_color32(vec3 pt, vec3 color) {
   return color;
}
float rbox21(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color21(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem33(vec3 pt)
{
   float v1 = color_choose32(pt,vec3(1.0, 0.5, 0.0));
   float v2 = rbox21(pt,vec3(-30.0, 20.0, -20.0),vec3(30.0, 70.0, 20.0),5.0);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color33(vec3 pt)
{
   float val = color_choose32(pt,vec3(1.0, 0.5, 0.0));
   if (val>-0.8 && val<0.8) return color_choose_color32(pt,vec3(1.0, 0.5, 0.0));
   return rbox_color21(pt,vec3(-30.0, 20.0, -20.0),vec3(30.0, 70.0, 20.0),5.0);
}
float sphere8(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color8(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float line9(vec3 pt, vec3 tl, vec3 br, float line_width1, float line_width2)
{
   vec3 pa = pt-tl, ba = br-tl;
   float h = dot(pa,ba)/dot(ba,ba) ;
   if (h<0.0 || h>1.0) return length(pa-ba*h)+0.8;
   return length( pa - ba*h ) - ((1.0-h)*line_width1+h*line_width2);
}
vec3 line_color9(vec3 pt, vec3 tl, vec3 br, float line_width1, float line_width2)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem10(vec3 pt)
{
   float v1 = sphere8(vec3(0.0, -30.0, 0.0),30.0,pt);
   float v2 = line9(pt,vec3(0.0, -30.0, 28.0),vec3(0.0, -30.0, 50.0),10.0,3.0);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color10(vec3 pt)
{
   float val = sphere8(vec3(0.0, -30.0, 0.0),30.0,pt);
   if (val>-0.8 && val<0.8) return sphere_color8(vec3(0.0, -30.0, 0.0),30.0,pt);
   return line_color9(pt,vec3(0.0, -30.0, 28.0),vec3(0.0, -30.0, 50.0),10.0,3.0);
}
float sphere11(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color11(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float sphere12(vec3 center, float radius, vec3 pt)
{
   pt-=center;
   return length(pt)-radius;
}
vec3 sphere_color12(vec3 center, float radius, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem13(vec3 pt)
{
   float v1 = sphere11(vec3(10.0, -40.0, 25.0),10.0,pt);
   float v2 = sphere12(vec3(-10.0, -40.0, 25.0),10.0,pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color13(vec3 pt)
{
   float val = sphere11(vec3(10.0, -40.0, 25.0),10.0,pt);
   if (val>-0.8 && val<0.8) return sphere_color11(vec3(10.0, -40.0, 25.0),10.0,pt);
   return sphere_color12(vec3(-10.0, -40.0, 25.0),10.0,pt);
}
float and_not14(vec3 pt)
{
   float v1 = or_elem10(pt);
   float v2 = or_elem13(pt);
   float res = max(v1,-v2);
   return res;
}
vec3 and_not_color14(vec3 pt)
{
   float v = or_elem10(pt);
   if (v>-0.8 && v<0.8) return or_elem_color10(pt);
   return or_elem_color13(pt);
}
float color_choose15(vec3 pt, vec3 color) {
   return and_not14(pt);
}
vec3 color_choose_color15(vec3 pt, vec3 color) {
   return color;
}
float rbox16(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color16(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem26(vec3 pt)
{
   float v1 = color_choose15(pt,vec3(1.0, 0.0, 1.0));
   float v2 = rbox16(pt,vec3(-30.0, 0.0, -20.0),vec3(30.0, 20.0, 20.0),5.0);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color26(vec3 pt)
{
   float val = color_choose15(pt,vec3(1.0, 0.0, 1.0));
   if (val>-0.8 && val<0.8) return color_choose_color15(pt,vec3(1.0, 0.0, 1.0));
   return rbox_color16(pt,vec3(-30.0, 0.0, -20.0),vec3(30.0, 20.0, 20.0),5.0);
}
float or_elem34(vec3 pt)
{
   float v1 = or_elem33(pt);
   float v2 = or_elem26(pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color34(vec3 pt)
{
   float val = or_elem33(pt);
   if (val>-0.8 && val<0.8) return or_elem_color33(pt);
   return or_elem_color26(pt);
}
float rbox17(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color17(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float rbox19(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color19(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem27(vec3 pt)
{
   float v1 = rbox17(pt,vec3(30.0, 0.0, -10.0),vec3(50.0, 50.0, 10.0),5.0);
   float v2 = rbox19(pt,vec3(30.0, 50.0, -10.0),vec3(50.0, 70.0, 10.0),5.0);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color27(vec3 pt)
{
   float val = rbox17(pt,vec3(30.0, 0.0, -10.0),vec3(50.0, 50.0, 10.0),5.0);
   if (val>-0.8 && val<0.8) return rbox_color17(pt,vec3(30.0, 0.0, -10.0),vec3(50.0, 50.0, 10.0),5.0);
   return rbox_color19(pt,vec3(30.0, 50.0, -10.0),vec3(50.0, 70.0, 10.0),5.0);
}
float rotx28(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(          vec3(1.0, 0.0, 0.0),
          vec3(0.0,cos(angle),sin(angle)),
          vec3(0.0,-sin(angle),cos(angle)));
   float v1 = or_elem27(center+m*(pt-center));
   return v1;
}
vec3 rotx_color28(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(          vec3(1.0, 0.0, 0.0),
          vec3(0.0,cos(angle),sin(angle)),
          vec3(0.0,-sin(angle),cos(angle)));
   vec3 v1 = or_elem_color27(center+m*(pt-center));
   return v1;
}
float color_choose29(vec3 pt, vec3 color) {
   return rotx28(pt,vec3(40.0, 10.0, 0.0),1.5*cos(time*3.0));
}
vec3 color_choose_color29(vec3 pt, vec3 color) {
   return color;
}
float or_elem35(vec3 pt)
{
   float v1 = or_elem34(pt);
   float v2 = color_choose29(pt,vec3(1.0, 0.5, 0.0));
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color35(vec3 pt)
{
   float val = or_elem34(pt);
   if (val>-0.8 && val<0.8) return or_elem_color34(pt);
   return color_choose_color29(pt,vec3(1.0, 0.5, 0.0));
}
float or_elem42(vec3 pt)
{
   float v1 = color_choose41(pt,vec3(0.0, 1.0, 1.0));
   float v2 = or_elem35(pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color42(vec3 pt)
{
   float val = color_choose41(pt,vec3(0.0, 1.0, 1.0));
   if (val>-0.8 && val<0.8) return color_choose_color41(pt,vec3(0.0, 1.0, 1.0));
   return or_elem_color35(pt);
}
float rbox22(vec3 pt, vec3 tl, vec3 br, float r)
{
   pt-=tl;
   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s+vec3(r),0.0))-r;
}
vec3 rbox_color22(vec3 pt, vec3 tl, vec3 br, float r)
{
   return vec3(1.0,1.0,1.0);
}
float cube24(vec3 tl, vec3 br, vec3 pt)
{
   pt-=tl;   vec3 s = br-tl;
   s/=2.0;
   pt-=s;
   return length(max(abs(pt)-s,0.0));
}
vec3 cube_color24(vec3 tl, vec3 br, vec3 pt)
{
   return vec3(1.0,1.0,1.0);
}
float or_elem36(vec3 pt)
{
   float v1 = rbox22(pt,vec3(-30.0, 70.0, -10.0),vec3(-5.0, 100.0, 10.0),5.0);
   float v2 = cube24(vec3(-30.0, 90.0, -5.0),vec3(-5.0, 100.0, 20.0),pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color36(vec3 pt)
{
   float val = rbox22(pt,vec3(-30.0, 70.0, -10.0),vec3(-5.0, 100.0, 10.0),5.0);
   if (val>-0.8 && val<0.8) return rbox_color22(pt,vec3(-30.0, 70.0, -10.0),vec3(-5.0, 100.0, 10.0),5.0);
   return cube_color24(vec3(-30.0, 90.0, -5.0),vec3(-5.0, 100.0, 20.0),pt);
}
float trans37(vec3 pt, vec3 delta)
{
   pt-=delta;
   return or_elem36(pt);
}
vec3 trans_color37(vec3 pt, vec3 delta)
{
    pt-=delta;
    return or_elem_color36(pt);
}
float color_choose38(vec3 pt, vec3 color) {
   return trans37(pt,vec3(0.0,0.0,10.0*cos(time*3.0)));
}
vec3 color_choose_color38(vec3 pt, vec3 color) {
   return color;
}
float or_elem43(vec3 pt)
{
   float v1 = or_elem42(pt);
   float v2 = color_choose38(pt,vec3(0.0, 1.0, 1.0));
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color43(vec3 pt)
{
   float val = or_elem42(pt);
   if (val>-0.8 && val<0.8) return or_elem_color42(pt);
   return color_choose_color38(pt,vec3(0.0, 1.0, 1.0));
}
float or_elem45(vec3 pt)
{
   float v1 = or_elem7(pt);
   float v2 = or_elem43(pt);
   float res = min(v1,v2);
   return res;
}
vec3 or_elem_color45(vec3 pt)
{
   float val = or_elem7(pt);
   if (val>-0.8 && val<0.8) return or_elem_color7(pt);
   return or_elem_color43(pt);
}
float from_obj_color44(vec3 pt, float time) {
    return or_elem7(pt);
}
vec3 from_obj_color_color44(vec3 pt, float time) {
   return or_elem_color7(pt);
}
float bounding_prim_47(vec3 pt)
{
    float dist = sphere46(vec3(0.0, 50.0, 0.0),120.0,pt);
    if (dist < 0.0) {
       return or_elem45(pt);
    } else {
       return from_obj_color44(pt,time);
    }
}
vec3 bounding_prim_color_47(vec3 pt)
{
    float dist = sphere46(vec3(0.0, 50.0, 0.0),120.0,pt);
    if (dist < 0.0) {
       return or_elem_color45(pt);
    } else {
       return from_obj_color_color44(pt,time);
    }
}
float roty48(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(vec3(cos(angle),0.0,sin(angle)),
          vec3(0.0, 1.0, 0.0),
          vec3(-sin(angle),0.0,cos(angle)));
   float v1 = bounding_prim_47(center+m*(pt-center));
   return v1;
}
vec3 roty_color48(vec3 pt, vec3 center, float angle)
{
  mat3 m = mat3(vec3(cos(angle),0.0,sin(angle)),
          vec3(0.0, 1.0, 0.0),
          vec3(-sin(angle),0.0,cos(angle)));
   vec3 v1 = bounding_prim_color_47(center+m*(pt-center));
   return v1;
}
float from_obj_color49(vec3 pt, float time) {
    return roty48(pt,vec3(0.0,0.0,0.0),time/1.25);
}
vec3 from_obj_color_color49(vec3 pt, float time) {
   return roty_color48(pt,vec3(0.0,0.0,0.0),time/1.25);
}
vec3 normal50(vec3 pt, float time)
{
  float fx = from_obj_color49(pt+vec3(1.0,0.0,0.0),time) - from_obj_color49(pt-vec3(1.0,0.0,0.0),time);
  float fy = from_obj_color49(pt+vec3(0.0,1.0,0.0),time) - from_obj_color49(pt-vec3(0.0,1.0,0.0),time);
  float fz = from_obj_color49(pt+vec3(0.0,0.0,1.0),time) - from_obj_color49(pt-vec3(0.0,0.0,1.0),time);
  return normalize(vec3(-fx,-fy,-fz))/2.0+vec3(0.5,0.5,0.5);
}
float obj50(vec3 pt, float time)
{
   return from_obj_color49(pt,time);
}
vec3 obj_color50(vec3 pt, float time)
{
   return normal50(pt,time);
}
float color_mix51(vec3 pt, float t) {
   return roty48(pt,vec3(0.0,0.0,0.0),time/1.25);
}
vec3 color_mix_color51(vec3 pt, float t) {
   vec3 col1 = roty_color48(pt,vec3(0.0,0.0,0.0),time/1.25);
   vec3 col2 = obj_color50(pt,time);
   return mix(col1, col2, t);
}
float softshadow52(vec3 pt, vec3 rd, float mint, float maxt, float k)
{
   float res = 1.0;
   float t = mint;
   for(int i=0;i<256;i++)
   {
      float h = color_mix51(pt + rd*t,0.6);
      if (h<0.001) return 0.0;
      res = min(res, k*h/t);
      t += h;
      if (t>maxt) break;
    }
    return res;
}
float softshadow_obj52(vec3 pt, vec3 rd, float mint, float maxt, float k, float strong) {
   return color_mix51(pt,0.6);
}
vec3 softshadow_color52(vec3 pt, vec3 rd, float mint, float maxt, float k, float strong) {
   vec3 color = color_mix_color51(pt,0.6);
   float shadow = softshadow52(pt,rd,mint,maxt,k);
   return (shadow/strong+(1.0-1.0/strong))*color;
}
float ao53(vec3 pt, vec3 n, float d, float i)
{
    float o = 0.0;
    for(float i=1.;i>0.;i--) {
      o-=(i*d-abs(softshadow_obj52(pt+n*i*d,vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0)))/pow(2.,i);
    }
    return o;
}
vec3 normal53(vec3 pt, float time)
{
  float fx = softshadow_obj52(pt+vec3(1.0,0.0,0.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0) - softshadow_obj52(pt-vec3(1.0,0.0,0.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0);
  float fy = softshadow_obj52(pt+vec3(0.0,1.0,0.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0) - softshadow_obj52(pt-vec3(0.0,1.0,0.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0);
  float fz = softshadow_obj52(pt+vec3(0.0,0.0,1.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0) - softshadow_obj52(pt-vec3(0.0,0.0,1.0),vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0);
  return normalize(vec3(-fx,-fy,-fz))/2.0+vec3(0.5,0.5,0.5);
}
float ao_obj53(vec3 pt, float d, float i)
{
   return softshadow_obj52(pt,vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0);
}
vec3 ao_color53(vec3 pt, float d, float i)
{
   vec3 n = normal53(pt,time);
   float ao = ao53(pt,n,d,i);
   ao = clamp(ao,0.0,1.0);
   vec3 c = softshadow_color52(pt,vec3(-20.0, -40.0, -20.0),0.0,1.0,2.0,8.0);
   vec3 c2 = mix(c,vec3(1.0,1.0,1.0),ao);
   return c2;
}
vec3 ray(vec3 p1, vec3 p2, float t)
{
   return p1 + t*(p2-p1);
}
float solve(vec3 p1, vec3 p2, float t_0, float t_1, float time)
{
    float t = t_0;
    for(int i=0;i<600;i++)
    {
       vec3 pt = ray(p1,p2,t);
       float Ht = ao_obj53(pt,6.2,50.0);
       if (abs(Ht)<0.5) return t;
       if (t>t_1) return 0.0;
       t+= Ht / 5.0;
    }
    return 0.0;
}
vec3 render(vec3 p0, vec3 p1)
{
   float t = solve(p0,p1,0.0, 1600.0, time);
   vec3 pt = ray(p0,p1, t);
   vec3 rgb = ao_color53(pt,6.2,50.0);
   return rgb;
}
void main( void ) {

	vec2 pos = ( scaled_gl_FragCoord.xy / resolution.yy );
	pos = vec2(pos.x,1.0-pos.y);
        vec3 p0 = vec3(pos-vec2(0.5),-400.0);
	vec3 p1 = vec3(pos*2.0-vec2(1.0),-399.0);
        vec3 rgb = render(p0,p1);
	gl_FragColor = vec4( rgb, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}